<?php $__env->startSection('title', 'تعديل مسابقة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>تعديل مسابقة</h2>

    <!-- عرض الأخطاء -->
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- نموذج تعديل المسابقة -->
    <form action="<?php echo e(route('competitions.update', $competition->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <!-- اسم المسابقة -->
        <div class="mb-3">
            <label for="competition_name" class="form-label">اسم المسابقة</label>
            <input type="text" class="form-control" id="competition_name" name="competition_name" value="<?php echo e(old('competition_name', $competition->competition_name)); ?>" required>
        </div>
        <!-- هل المسابقة متاحة -->
        <div class="mb-3">
            <label for="is_available" class="form-label">هل المسابقة متاحة؟</label>
            <select class="form-select" id="is_available" name="is_available" required>
                <option value="1" <?php echo e(old('is_available', $competition->is_available) ? 'selected' : ''); ?>>نعم</option>
                <option value="0" <?php echo e(!old('is_available', $competition->is_available) ? 'selected' : ''); ?>>لا</option>
            </select>
        </div>
        <!-- الرصيد البدائي للعملاء -->
        <div class="mb-3">
            <label for="balance" class="form-label">الرصيد البدائي للعملاء ($)</label>
            <input type="number" step="0.01" class="form-control" id="balance" name="balance" value="<?php echo e(old('balance', $competition->balance)); ?>" required>
        </div>
        <!-- الجائزة -->
        <div class="mb-3">
            <label for="gift" class="form-label">الجائزة</label>
            <input type="text" class="form-control" id="gift" name="gift" value="<?php echo e(old('gift', $competition->gift)); ?>" required>
        </div>
        <!-- نوع الحساب -->
        <div class="mb-3">
            <label for="account_type" class="form-label">نوع الحساب</label>
            <select class="form-select" id="account_type" name="account_type" required>
                <option value="demo" <?php echo e(old('account_type', $competition->account_type) === 'demo' ? 'selected' : ''); ?>>حساب تجريبي</option>
                <option value="live" <?php echo e(old('account_type', $competition->account_type) === 'live' ? 'selected' : ''); ?>>حساب حقيقي</option>
            </select>
        </div>
        <!-- كروب التداول -->
        <div class="mb-3">
            <label for="trading_group" class="form-label">كروب التداول</label>
            <input type="text" class="form-control" id="trading_group" name="trading_group" value="<?php echo e(old('trading_group', $competition->trading_group)); ?>" required>
        </div>
        <!-- هل يوجد ستوب؟ -->
        <div class="mb-3">
            <label for="has_stop" class="form-label">هل يوجد ستوب؟</label>
            <select class="form-select" id="has_stop" name="has_stop" required>
                <option value="1" <?php echo e(old('has_stop', $competition->has_stop) == 1 ? 'selected' : ''); ?>>نعم</option>
                <option value="0" <?php echo e(old('has_stop', $competition->has_stop) == 0 ? 'selected' : ''); ?>>لا</option>
            </select>
        </div>
        <!-- مقدار الستور أو الخسارة -->
        <div class="mb-3" id="stop_amount_container">
            <label for="stop_amount" class="form-label">مقدار الستور أو الخسارة ($)</label>
            <input type="number" step="0.01" class="form-control" id="stop_amount" name="stop_amount" value="<?php echo e(old('stop_amount', $competition->stop_amount)); ?>">
        </div>
        <!-- تاريخ انتهاء التقديم -->
        <div class="mb-3">
            <label for="submission_end_date" class="form-label">تاريخ انتهاء التقديم</label>
            <input type="datetime-local" class="form-control" id="submission_end_date" name="submission_end_date" value="<?php echo e(\Carbon\Carbon::parse(old('submission_end_date', $competition->submission_end_date))->format('Y-m-d\TH:i')); ?>" required>
        </div>
        <!-- تاريخ انتهاء المسابقة -->
        <div class="mb-3">
            <label for="competition_end_date" class="form-label">تاريخ انتهاء المسابقة</label>
            <input type="datetime-local" class="form-control" id="competition_end_date" name="competition_end_date" value="<?php echo e(\Carbon\Carbon::parse(old('competition_end_date', $competition->competition_end_date))->format('Y-m-d\TH:i')); ?>" required>
        </div>
        <!-- زر الحفظ -->
        <button type="submit" class="btn btn-primary">تحديث</button>
        <a href="<?php echo e(route('competitions.index')); ?>" class="btn btn-secondary">إلغاء</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const hasStopSelect = document.getElementById('has_stop');
        const stopAmountContainer = document.getElementById('stop_amount_container');
        const stopAmountInput = document.getElementById('stop_amount');

        function toggleStopAmount() {
            if (hasStopSelect.value === '1') {
                stopAmountContainer.style.display = 'block';
                stopAmountInput.required = true;
            } else {
                stopAmountContainer.style.display = 'none';
                stopAmountInput.required = false;
                stopAmountInput.value = '';
            }
        }

        hasStopSelect.addEventListener('change', toggleStopAmount);

        // Initial call
        toggleStopAmount();
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\LaravelProjects\competition-system\resources\views/admin/competitions/edit.blade.php ENDPATH**/ ?>