 <!-- استخدم تخطيط الإدمن المخصص -->

<?php $__env->startSection('title', 'الطلبات المعلقة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>الطلبات المعلقة</h2>

    <!-- عرض رسالة النجاح -->
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- جدول الطلبات المعلقة -->
    <?php if($pendingRequests->isEmpty()): ?>
        <p>لا توجد طلبات معلقة.</p>
    <?php else: ?>
        <table class="table table-striped table-bordered" id="pendingRequestsTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>تاريخ الطلب</th>
                    <th>الصورة</th>
                    <th>الاسم</th>
                    <th>رقم الهاتف</th>
                    <th>البريد الإلكتروني</th>
                    <th>الاستراتيجية</th>
                    <th>المسابقة المحددة</th>
                    <th>الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $pendingRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($request->created_at)->format('d-m-Y H:i')); ?></td>
                        <td>
                            <img src="<?php echo e(asset('images/' . $request->photo)); ?>" alt="<?php echo e($request->first_name); ?> <?php echo e($request->last_name); ?>" width="60" height="60" class="rounded-circle">
                        </td>
                        <td><?php echo e($request->first_name); ?> <?php echo e($request->last_name); ?></td>
                        <td><?php echo e($request->phone); ?></td>
                        <td><?php echo e($request->email); ?></td>
                        <td><?php echo e($request->strategy); ?></td>
                        <td><?php echo e($request->competition->competition_name); ?></td>
                        <td>
                            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#approveModal<?php echo e($request->id); ?>">موافقة</button>
                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo e($request->id); ?>">رفض</button>

                            <!-- نموذج الموافقة المعدل -->
                                    <div class="modal fade" id="approveModal<?php echo e($request->id); ?>" tabindex="-1" aria-labelledby="approveModalLabel<?php echo e($request->id); ?>" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <form action="<?php echo e(route('admin.pending_requests.approve', $request->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="approveModalLabel<?php echo e($request->id); ?>">موافقة على الطلب</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="account_number<?php echo e($request->id); ?>" class="form-label">رقم حساب التداول</label>
                                                            <input type="text" class="form-control" id="account_number<?php echo e($request->id); ?>" name="account_number" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="trading_password<?php echo e($request->id); ?>" class="form-label">كلمة مرور حساب التداول</label>
                                                            <input type="password" class="form-control" id="trading_password<?php echo e($request->id); ?>" name="trading_password" required>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                        <button type="submit" class="btn btn-primary">موافقة</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>


                            <!-- نموذج الرفض المعدل -->
                            <div class="modal fade" id="rejectModal<?php echo e($request->id); ?>" tabindex="-1" aria-labelledby="rejectModalLabel<?php echo e($request->id); ?>" aria-hidden="true">
                                <div class="modal-dialog">
                                    <form action="<?php echo e(route('admin.pending_requests.reject', $request->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="rejectModalLabel<?php echo e($request->id); ?>">رفض الطلب</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="mb-3">
                                                    <label for="rejection_reason<?php echo e($request->id); ?>" class="form-label">سبب الرفض</label>
                                                    <input type="text" class="form-control" id="rejection_reason<?php echo e($request->id); ?>" name="rejection_reason" required>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value="1" id="send_reason<?php echo e($request->id); ?>" name="send_reason">
                                                    <label class="form-check-label" for="send_reason<?php echo e($request->id); ?>">
                                                        إرسال سبب الرفض إلى العميل
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                <button type="submit" class="btn btn-danger">رفض</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">

<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap JS (for modals) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    $(document).ready(function() {
        $('#pendingRequestsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\competition-system\resources\views/admin/pending_requests/index.blade.php ENDPATH**/ ?>