 <!-- استخدم تخطيط الإدمن إذا كان موجودًا -->

<?php $__env->startSection('title', 'إضافة مسابقة جديدة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>إضافة مسابقة جديدة</h2>

    <!-- عرض الأخطاء -->
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- نموذج إضافة المسابقة -->
    <form action="<?php echo e(route('competitions.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <!-- اسم المسابقة -->
        <div class="mb-3">
            <label for="competition_name" class="form-label">اسم المسابقة</label>
            <input type="text" class="form-control" id="competition_name" name="competition_name" required>
        </div>
        <!-- هل المسابقة متاحة -->
        <div class="mb-3">
            <label for="is_available" class="form-label">هل المسابقة متاحة؟</label>
            <select class="form-select" id="is_available" name="is_available" required>
                <option value="" disabled selected>اختر الحالة</option>
                <option value="1">نعم</option>
                <option value="0">لا</option>
            </select>
        </div>
        <!-- الرصيد البدائي للعملاء -->
        <div class="mb-3">
            <label for="balance" class="form-label">الرصيد البدائي للعملاء ($)</label>
            <input type="number" step="0.01" class="form-control" id="balance" name="balance" required>
        </div>
        <!-- الجائزة -->
        <div class="mb-3">
            <label for="gift" class="form-label">الجائزة</label>
            <input type="text" class="form-control" id="gift" name="gift" required>
        </div>
        <!-- تاريخ انتهاء التقديم -->
        <div class="mb-3">
            <label for="submission_end_date" class="form-label">تاريخ انتهاء التقديم</label>
            <input type="datetime-local" class="form-control" id="submission_end_date" name="submission_end_date" required>
        </div>
        <!-- تاريخ انتهاء المسابقة -->
        <div class="mb-3">
            <label for="competition_end_date" class="form-label">تاريخ انتهاء المسابقة</label>
            <input type="datetime-local" class="form-control" id="competition_end_date" name="competition_end_date" required>
        </div>
        <!-- زر الحفظ -->
        <button type="submit" class="btn btn-primary">حفظ</button>
        <a href="<?php echo e(route('competitions.index')); ?>" class="btn btn-secondary">إلغاء</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\competition-system\resources\views/admin/competitions/create.blade.php ENDPATH**/ ?>