 <!-- استخدم تخطيط الإدمن إذا كان موجودًا -->

<?php $__env->startSection('title', 'إدارة المسابقات'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>إدارة المسابقات</h2>

    <!-- عرض رسالة النجاح -->
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- زر إضافة مسابقة جديدة -->
    <div class="mb-4">
        <a href="<?php echo e(route('competitions.create')); ?>" class="btn btn-success">إضافة مسابقة جديدة</a>
    </div>

    <!-- قسم المسابقات الحالية -->
    <div class="card mb-4">
        <div class="card-header">
            <h4>المسابقات الحالية</h4>
        </div>
        <div class="card-body">
            <?php if($currentCompetitions->isEmpty()): ?>
                <p>لا توجد مسابقات حالية.</p>
            <?php else: ?>
                <table class="table table-striped table-bordered" id="currentCompetitionsTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم المسابقة</th>
                            <th>متاحة</th>
                            <th>الرصيد البدائي</th>
                            <th>الجائزة</th>
                            <th>تاريخ انتهاء التقديم</th>
                            <th>تاريخ انتهاء المسابقة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $currentCompetitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($competition->competition_name); ?></td>
                                <td><?php echo e($competition->is_available ? 'نعم' : 'لا'); ?></td>
                                <td>$<?php echo e(number_format($competition->balance, 2)); ?></td>
                                <td>
                                    <?php if(is_numeric($competition->gift)): ?>
                                        $<?php echo e(number_format($competition->gift, 2)); ?>

                                    <?php else: ?>
                                        <?php echo e($competition->gift); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(\Carbon\Carbon::parse($competition->submission_end_date)->format('d-m-Y H:i')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($competition->competition_end_date)->format('d-m-Y H:i')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('competitions.edit', $competition->id)); ?>" class="btn btn-primary btn-sm">تعديل</a>
                                    <form action="<?php echo e(route('competitions.destroy', $competition->id)); ?>" method="POST" style="display:inline-block;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من إنهاء هذه المسابقة؟')">إنهاء</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>

    <!-- قسم المسابقات المنتهية -->
    <div class="card mb-4">
        <div class="card-header">
            <h4>المسابقات المنتهية</h4>
        </div>
        <div class="card-body">
            <?php if($endedCompetitions->isEmpty()): ?>
                <p>لا توجد مسابقات منتهية.</p>
            <?php else: ?>
                <table class="table table-striped table-bordered" id="endedCompetitionsTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم المسابقة</th>
                            <th>متاحة</th>
                            <th>الرصيد البدائي</th>
                            <th>الجائزة</th>
                            <th>تاريخ انتهاء التقديم</th>
                            <th>تاريخ انتهاء المسابقة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $endedCompetitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($competition->competition_name); ?></td>
                                <td><?php echo e($competition->is_available ? 'نعم' : 'لا'); ?></td>
                                <td>$<?php echo e(number_format($competition->balance, 2)); ?></td>
                                <td>
                                    <?php if(is_numeric($competition->gift)): ?>
                                        $<?php echo e(number_format($competition->gift, 2)); ?>

                                    <?php else: ?>
                                        <?php echo e($competition->gift); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(\Carbon\Carbon::parse($competition->submission_end_date)->format('d-m-Y H:i')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($competition->competition_end_date)->format('d-m-Y H:i')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('competitions.edit', $competition->id)); ?>" class="btn btn-primary btn-sm">تعديل</a>
                                    <!-- يمكن إضافة إجراءات أخرى مثل عرض المتسابقين -->
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // تفعيل خاصية البحث والفرز في جدول المسابقات الحالية
        $('#currentCompetitionsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true
        });

        // تفعيل خاصية البحث والفرز في جدول المسابقات المنتهية
        $('#endedCompetitionsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\competition-system\resources\views/admin/competitions/index.blade.php ENDPATH**/ ?>