 <!-- استخدام تخطيط الإدمن المخصص -->

<?php $__env->startSection('title', 'المتسابقون المكتملون'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/js/currentParticipants.js']); ?>
<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>المتسابقون المكتملون</h2>

    <!-- عرض رسالة النجاح -->
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- جدول المتسابقين المكتملين -->
    <?php if($completedParticipants->isEmpty()): ?>
        <p>لا توجد متسابقين مكتملين.</p>
    <?php else: ?>
        <table class="table table-striped table-bordered" id="completedParticipantsTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>تاريخ الاكتمال</th>
                    <th>الصورة</th>
                    <th>الاسم</th>
                    <th>رقم الهاتف</th>
                    <th>البريد الإلكتروني</th>
                    <th>الاستراتيجية</th>
                    <th>رصيد الحساب</th>
                    <th>رقم الحساب</th>
                    <th>سبب الرفض</th> <!-- إزالة عمود كلمة المرور -->
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $completedParticipants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($participant->updated_at)->format('d-m-Y H:i')); ?></td>
                        <td>
                            <img src="<?php echo e(asset('images/' . $participant->photo)); ?>" alt="<?php echo e($participant->first_name); ?> <?php echo e($participant->last_name); ?>" width="60" height="60" class="rounded-circle">
                        </td>
                        <td><?php echo e($participant->first_name); ?> <?php echo e($participant->last_name); ?></td>
                        <td><?php echo e($participant->phone); ?></td>
                        <td><?php echo e($participant->email); ?></td>
                        <td><?php echo e($participant->strategy); ?></td>
                        <td>$<?php echo e(number_format($participant->account_balance, 2)); ?></td>
                        <td><?php echo e($participant->account_number); ?></td>
                        <td><?php echo e($participant->rejection_reason); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\competition-system\resources\views/admin/participants/completed.blade.php ENDPATH**/ ?>