import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';


export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/css/currentParticipants.css',
                'resources/js/app.js',
                'resources/js/home.js',
                'resources/js/competition.js',
                'resources/js/currentParticipants.js',
            ],
            refresh: true,
        }),
    ],
    server: {
        https: true, // فقط لبيئة التطوير
    },
    base: 'https://competition.ri-fx.com/', // تأكد من أن القاعدة تضع https
    resolve: {
        alias: {
            '@': '/resources/js',
        },
    },
});
